﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Xml;
using System.Windows.Forms;
using System.Text.RegularExpressions;
using PI.FM.N000.Base.WinForms.Ribbon;
using Gemini.Core.WinForms.Controls.Type;
using Gemini.Core.WinForms.Controls.Interface;
using Gemini.Core.WinForms.Base;


namespace PI.ZB.N1200.ELearning.WinForms.CompetencePart
{
    public partial class UCCompetencePartDetails : PI.FM.N000.Base.WinForms.Controls.UCBODetails<BL.BO.CompetencePart, BL.BO.CompetencePart.Search>
    {
        private const int _IndexTabCompetencePartDetails = 0;
        private const int _IndexTabCompetencePartCoursess = 1;
        private const int _IndexTabCompetencePartDescription = 2;
        protected     int _IndexTabSystemInformation    = 3;

        private PI.ZB.N1200.ELearning.BL.ZSBELearning _blZSBELearning = null;

        private UCTabCompetencePartDetails      _tabCompetencePartDetails = null;
        private UCTabCompetencePartDescription  _tabCompetencePartDescription = null;
        private UCTabCompetencePartCourses      _tabCompetencePartCourses = null;

        internal virtual PI.ZB.N1200.ELearning.BL.ZSBELearning BLZSBELearning
        {
            get
            {
                if (_blZSBELearning == null)
                {
                    _blZSBELearning = new PI.ZB.N1200.ELearning.BL.ZSBELearning(Environment);
                }
                return _blZSBELearning;
            }
        }

        public UCTabCompetencePartDetails TabCompetencePartDetails
        {
            get
            {
                if (_tabCompetencePartDetails == null)
                {
                    _tabCompetencePartDetails = new UCTabCompetencePartDetails();
                }
                return _tabCompetencePartDetails;
            }
        }

        public UCTabCompetencePartDescription TabCompetencePartDescription
        {
            get
            {
                if (_tabCompetencePartDescription == null)
                {
                    _tabCompetencePartDescription = new UCTabCompetencePartDescription();
                }
                return _tabCompetencePartDescription;
            }
        }

        public UCTabCompetencePartCourses TabCompetencePartCourses
        {
            get
            {
                if (_tabCompetencePartCourses == null)
                {
                    _tabCompetencePartCourses = new UCTabCompetencePartCourses();
                }
                return _tabCompetencePartCourses;
            }
        }

        protected int IndexTabSystemInformation
        {
            set
            {
                _IndexTabSystemInformation = value;
            }
            get
            {
                return _IndexTabSystemInformation;
            }
        }

        public UCCompetencePartDetails()
        {
            InitializeComponent();

            AddStandardControlTabs();

            MinimumHorizontalSize = 420;
            MinimumVerticalSize = 420;
        }

        protected void AddStandardControlTabs()
        {
            this.AddControlAtTab(_IndexTabCompetencePartDetails, TabCompetencePartDetails, "Ustawienia");
            this.AddControlAtTab(_IndexTabCompetencePartCoursess, TabCompetencePartCourses, "Kursy składowe");
            this.AddControlAtTab(_IndexTabCompetencePartDescription, TabCompetencePartDescription, "Opis");
            this.AddControlAtTab(_IndexTabSystemInformation, TabSystemInformation, "Informacje systemowe");
        }

        public override void Initialize(Gemini.Core.WinForms.Interface.IPlugIn ParentPlugIn, Gemini.Core.WinForms.Interface.IEnvironment ParentEnvironment)
        {
            base.Initialize(ParentPlugIn, ParentEnvironment);

            TabCompetencePartDetails.Initialize(this, Environment, Plugin);
            TabCompetencePartCourses.Initialize(this, Environment, Plugin);
            TabCompetencePartDescription.Initialize(this, Environment, Plugin);
            TabSystemInformation.Initialize(this, Environment, Plugin);
        }

        protected override Gemini.Core.BL.Base.MethodResult DoRemove()
        {
            return BLZSBELearning.CompetencePart.Remove(DataManager.Current);
        }

        protected override Gemini.Core.BL.Base.MethodResult DoSave()
        {
            Gemini.Core.BL.Base.MethodResult _methodResult = new Gemini.Core.BL.Base.MethodResult();

            TabCompetencePartDetails.Save();
            TabCompetencePartCourses.Save();
            TabCompetencePartDescription.Save();

            if (DataManager.Current.CompetenceTheoryID.HasValue && DataManager.Current.CompetenceCourseID.HasValue && DataManager.Current.CaseID.HasValue)
            {
                DataManager.Current.IsValid = true;
            }
            else
            {
                DataManager.Current.IsValid = false;
            }

            _methodResult = BLZSBELearning.CompetencePart.Save(DataManager.Current);

            return _methodResult;
        }

        protected override void DoExtendToolbarActions()
        {
            if (TabControl.SelectedTabPageIndex == _IndexTabCompetencePartDescription)
            {
                PI.FM.N000.Base.WinForms.Ribbon.HtmlRibbonToolbar.Extend();
            }
        }

        protected override bool DoRestore(long? ID)
        {
            bool _result = false;
            BL.BO.CompetencePart _CompetencePart = BLZSBELearning.CompetencePart.Restore(ID);
            if (_CompetencePart != null)
            {
                DataManager.LoadData(null, null, _CompetencePart);
                TabCompetencePartDetails.Restore();
                TabCompetencePartCourses.Restore();
                TabCompetencePartDescription.Restore();
                _result = true;
            }

            return _result;
        }

        protected override bool DoConfirmDelete()
        {
            bool _return = false;

            if (DataManager.Current != null)
            {
                FRemoveCompetencePart _dialog = Gemini.Core.WinForms.Base.Form.Create<FRemoveCompetencePart>(this.Plugin, Environment);
                _dialog.Initialize(BLZSBELearning, DataManager.Current);

                if (DialogResult.OK == _dialog.ShowDialog())
                {
                    _return = true;
                }
                else
                {
                    _return = false;
                }
            }
            return _return;
        }
    }
}
